**************************************
*** This file creates the figure 5 ***
**************************************

clear
clear matrix
set mem 500m

use nj_respondents_new.dta, clear

*** define exhaustion point:
* exhaustion date equal to last payment if UI exhausted
gen     exhaustdate = lpdate if weekspaid_all_end >= potdur_extnew

* exhaustion date equal to last payment date if UI ended + remaining weeks
replace exhaustdate = lpdate + 7*max(potdur_extnew - weekspaid_all_end, 0) if weekspaid_all_end < potdur_extnew & lpdate < 18377

* exhaustion date equal to extraction date (end of april 2010) + remaining weeks
replace exhaustdate = 18377  + 7*max(potdur_extnew - weekspaid_all_end, 0) if weekspaid_all_end < potdur_extnew & lpdate >=18377

* exhaustion censored if new claim filed
replace exhaustdate = . if date_new_claim!=.


*** weeks till exhaustion
gen wktoex = round((stopday-exhaustdate)/7)
quietly tab wktoex, gen(wktoex_)
drop wktoex_1

gen varwgt = curwkwgt
tab q2, gen(q2_)
drop q2_1
gen tw_jobsearch_rescaled = 60*tw_jobsearch/7


*** define variable to be used

* for top panel of figure 5, type:
local varxname = "tu_jobsearch"
local varxtitle = "Time spent on job search (yesterday), in min per day"

* for bottom panel of figure 5, type:
*local varxname = "tw_jobsearch_rescaled"
*local varxtitle = "Time spent on job search (last 7 days), in min per day"

*local varxname = "rwr"
*local varxtitle = "Reservation wage ratio"


gen varx = `varxname'

*** sample restriction: drop those with 0 weeks of potential duration and those age<20 or age>65 or not insample as usual
drop if potdur_extnew==0
keep if age>=20 & age<=65 & insample_wrkacc==1
keep wktoex* varx id q2_* varwgt


*** extract fixed effects
if "`varxname'"=="tu_jobsearch" {
areg varx wktoex_* q2_* [pw=varwgt], absorb(id)
predict xb if varx!=., xb
forvalues y=2(1)7 {
replace xb = xb - _b[q2_`y'] if q2_`y'==1
}
gen xborig = xb
}

if "`varxname'"!="tu_jobsearch" {
areg varx wktoex_* [pw=varwgt], absorb(id)
predict xb if varx!=., xb
gen xborig = xb
}

*** collapse by weeks till exhaustion
keep wktoex xb xborig varx varwgt
collapse xb xborig varx (count) N = xb [aw=varwgt], by(wktoex)
sort wktoex


*** define intercept at week -20 equal to average search at that time
drop if wktoex < -20
drop if wktoex > 6
drop if N<5
sort wktoex
replace xb     = varx[1] + xb - xborig[1]


*** figure 5
if "`varxname'"!="rwr" {
graph twoway line xb wktoex if wktoex>=-20 & wktoex<=5, ///
lpattern(solid dash dash) lcolor(black black black) lwidth(medthick thin thin) ///
xlabel(-20(5)5) ///
yscale(range(0(40)160)) ///
ylabel(0(40)160) ///
graphregion(color(white)) ///
ytitle("") ///
xline(0) legend(off) xtitle("Weeks until UI exhaustion") ///
note("Note: The figure removes individual fixed effects.")
graph export exhaustion_`varxname'.png, replace hei(1200) wid(1650)
graph export exhaustion_`varxname'.eps, replace
}

*title("`varxtitle'")
*note("Universe: Unemployed; no job offer yet accepted; age 20-65.")

if "`varxname'"=="rwr" {
graph twoway line xb wktoex if wktoex>=-20 & wktoex<=5, ///
lpattern(solid dash dash) lcolor(black black black) lwidth(medthick thin thin) ///
xlabel(-20(5)5) ///
yscale(range(0.85(0.05)1.05)) ///
ylabel(0.85(0.05)1.05) ///
graphregion(color(white)) ///
title("`varxtitle'") ytitle("") ///
xline(0) legend(off) xtitle("Weeks until UI exhaustion") ///
note("Universe: Unemployed; no job offer yet accepted; age 20-65.")
graph export exhaustion_`varxname'.png, replace hei(1200) wid(1650)
}


stop
